#!/usr/bin/perl

#a quick and experimental hack for a proxy that sits between aoc and telnet/zmud and attempts to grab items, pops, and namemaps
#eglin
#4/23/10
#tested (very very briefly) using Strawberry Perl (integrated CPAN;install Net::ProxyMod)
#"compiled" to AoCgrabber.exe for those w/o Perl installs w/ (CPAN:isntall pp, pp -o AoCgrabber.exe)
#if you modify & redistribute, please add a similar message here stating who you are, what you did, and when you did it

use strict;
use Carp;
use Net::ProxyMod;

my $localhost = 'localhost';
my $localport = 6969;
my $remotehost = 'pandapub.com';
my $remoteport = 4000;
my $debug = 1;

# create a new proxy object
my $p = Net::ProxyMod->new(-local_host => $localhost, -local_port => $localport, -remote_host => $remotehost, -remote_port => $remoteport, -debug => $debug, -mode => 'nonforking');

# wait for connection(s)
$p->get_conn(\&infunc, sub {return(@_)});

#static scope, as we might get the map across multiple packets
my($last_longname,$last_shortname) = (undef,undef);

# for packets going from the server to the client:
sub infunc
{
	my($data) = @_;
	if($data =~ /[\r\n]Object '(.*)', Item type: (.*)[\r\n]/) #$data probably contains an item
	{
		my(%item);
		my(@fields) = ("name", "damage", "dam", "hit", "armor", "ac", "kind", "wear", "weight", "value", "hp", "mana", "age", "str", "con", "wis", "int", "cha", "dex", "pearth", "pair", "pfire", "pwater", "pspirit", "mearth", "mair", "mfire", "mwater", "mspirit", "moves", "charges", "castlevel", "affects", "spells", "perc_cast", "antialignment", "flags", "anticlass");
		$item{$_} = 0 foreach @fields; #initialize everything to zero
		$item{'damage'} = $item{'affects'} = $item{'spells'} = $item{'flags'} = "''"; #all the other strings are guaranteed in any valid item
		$item{'kind'} = lc($2);
		$item{'name'} = $1;
		$item{'name'} =~ s/\'/\'\'/;
		$item{'kind'} =~ s/\W*$//;
		$item{'kind'} = "'".$item{'kind'}."'";
		$item{'name'} = "'".$item{'name'}."'";
		$item{'name'} =~ s/^[^\']*//;
		if($data =~ /[\r\n]Item will give you following abilities:\s*([\w\s\d]*)[\r\n]/)
		{
			$item{'affects'} = $1;
			$item{'affects'} =~s/\W*$//;
			$item{'affects'} = "'".$item{'affects'}."'";
		}
		if($data=~/[\r\n]Item is: (.*)[\r\n]/)
		{
			my $antialignment="";
			my $flags="";
			foreach my $word (split(" ", $1))
			{
				if(($word eq "!GOOD") or ($word eq "!EVIL") or($word eq "!NEUTRAL"))
				{
					$antialignment.="," if(length($antialignment));
					$antialignment.=$word;
				}
				else
				{
					$flags.="," if(length($flags));
					$flags.=$word;
				}
			}
			$item{'antialignment'} = "'".lc($antialignment)."'";
			$item{'flags'} = "'".lc($flags)."'";
		}
		if($data=~/[\r\n]+Can be worn on: (.*)[\s\r\n]+/)
		{
			$item{'wear'} = lc($1);
			$item{'wear'} eq 'take ' ? $item{'wear'} = "hold " : $item{'wear'}=~s/take //;
			$item{'wear'}=~s/\s*$//;
			$item{'wear'} = "'".$item{'wear'}."'";
		}
		if($data=~/[\n\r]Restricted Classes\s*:[\s\r\n]+(.*)[\r\n]Restricted Races\s*:[\s\r\n]+(.*)[\r\n]Restricted Clans\s*:[\s\r\n]+(.*)[\r\n]/)
		{
			$item{'anticlass'} = lc("$1, $2, $3");
			$item{'anticlass'}=~s/[\r\n]//g;
			$item{'anticlass'}=~s/, /,/g;
			$item{'anticlass'}=~s/none(,:?)*//g;
			$item{'anticlass'}=~s/,$//;
			$item{'anticlass'} = 'none' if $item{'anticlass'} eq '';
			$item{'anticlass'} = "'".$item{'anticlass'}."'";
			$item{'anticlass'}=~s/[^\']*$//;
		}
		if($data=~/[\n\r]Weight: (.*), Value: (.*)[\n\r]/)
		{
			$item{'weight'} = $1;
			$item{'value'} = $2;
			$item{'value'} =~ s/\D*$//;
		}
		while($data=~/[\n\r][\s\t]*Affects : (.*) By (.*)/g)
		{
			my $aff = lc($1);
			$aff = "dam" if("damroll" eq $aff);
			$aff = "hit" if("hitroll" eq $aff);
			$aff = "moves" if("move" eq $aff);
			$item{$aff} = lc($2);
			$item{$aff} =~ s/\D*$//;
		}
		if($data=~/[\n\r]Has (.*) charges, with (.*) charges left.[\n\r]/)
		{
			$item{'charges'} = $1;
		}
		if($data=~/[\n\r]Level (.*) spell of: (.*)[\n\r]/)
		{#assume there are no wands that proc
			$item{'castlevel'} = $1;
			$item{'spells'} = "'".lc($2)."'";
			$item{'perc_cast'} = 0;
		}
		if($data=~/[\n\r]Spell: (.*)   Level: (.*)  Charges:  (.*) left out of (.*) max[\n\r]/)
		{
			$item{'castlevel'} = $2;
			$item{'spells'} = "'".lc($1)."'";
			$item{'perc_cast'} = 0;
			$item{'charges'} = $3;
		}
		if($data=~/[\n\r]Level (.*) spells* of:\s*(.*)/s)
		{
			$item{'castlevel'} = $1;
			$item{'perc_cast'} = 0;
			$item{'spells'} = lc($2);
			$item{'spells'}=~s/[\n\r]restricted([\n\r]|.)*//;
			$item{'spells'}=~s/[\n\r]can affect you([\n\r]|.)*//;
			$item{'spells'}=~s/[\n\r]/, /g;
			$item{'spells'} = "'".$item{'spells'}."'";
		}
		if($data=~/[\n\r]Attack Spell: (.*)   Level: (.*)    Percentage: (.*)[\n\r]/)
		{
			$item{'spells'} = "'".lc($1)."'";
			$item{'castlevel'} = $2;
			$item{'perc_cast'} = $3;
			$item{'charges'} = 0;
		}
		if($data=~/[\n\r]AC-apply is ([-\d])+/)
		{
			$item{'ac'} = $1;
		}
		if($data=~/[\n\r]Damage Dice is \'(.*)\'[\n\r]/)
		{
			$item{'damage'} = "'".$1."'";
		}
		open item_file, ">>grabbed_items.csv" or return(@_);
		print item_file join(", ", (map {"$item{$_}"} @fields)) . "\n";
		close item_file;
		print "grabbed: " . $item{'name'} . "\n" if $debug > 0;
	}
	if($data=~/\[Auto-Auc\] : \w+ auctioning (.*), min is \d+\./)
	{
		$last_longname = $1;
		$last_longname = $1 if $last_longname =~ /^.{6}(.*).{9}$/;
		print "grabbed: longname = $1 from auction\n";
	}
	if($data=~/Object \'(.*)\'/)
	{
		$last_shortname = $1;
		$last_shortname =~ s/\'/\'\'/;
		if(defined($last_longname))
		{
			open namemap_file, ">>grabbed_namemaps.csv" or return(@_);
			print namemap_file "'$last_shortname', '$last_longname'\n";
			close namemap_file;
			print "grabbed: '$last_shortname' -> '$last_longname'\n" if $debug > 0;
			undef($last_longname);
		}
	}
	while($data=~/[\r\n\s(>\s:?)]*\w+ gets? (.*) from the corpse of (.*)\./g)
	{
		my ($what,$who) = ($1,$2);
		$who=~s/\'/\'\'/;
		$what=~s/\'/\'\'/;
		open pop_file, ">>grabbed_pops.csv" or return(@_);
		print pop_file "'$who', '$what'\n";
		close pop_file;
		print "grabbed: '$who' (pops) '$what'\n" if $debug > 0;
	}
	return(@_);
}

